import numpy
import matplotlib.pyplot as plt
import itertools
import random
import math


def zavislost():

    for n in range(40):

        a = 365
        prob = 1.
        for i in range(n):
            a -= 1
            prob = prob * (a/365)

        plt.plot(n + 1, 1 - prob, "bo")
        print(n + 1, 1 - prob)

    plt.show()

def comb(n, k):
    return math.factorial(n)/(math.factorial(n - k) * math.factorial(k))

def get_pst_tesne_vedle(n):

    pocet_sekv1 = math.factorial(365 - n) / math.factorial(365 - 2*n)
    pocet_sekv2 = n * math.factorial(364 - n) / math.factorial(365 - 2*n)
    pocet_all_sekv = 365 ** n

    prob = (pocet_sekv1 + pocet_sekv2)/pocet_all_sekv

    return 1 - prob

def get_pst_tesne_vedle_jirka(n):

    return 1 - comb(364 - n, n - 1) * math.factorial(n - 1)/(365 ** (n - 1))

def get_pst_tesne_vedle_spatne(n):

    a = 365
    prob = 1.
    for i in range(n - 1):
        a -= 3
        prob = prob * (a/365)

    return 1 - prob

def zavislost_tesne_vedle():

    for n in range(2, 40):

        prob_spatne = get_pst_tesne_vedle_spatne(n)
        prob_pokus = get_pst_tesne_vedle(n)
        # prob_jirka = get_pst_tesne_vedle_jirka(n)
        # plt.plot(n, prob_spatne, "bo")
        print(n, "%0.5f %0.5f" % (prob_spatne, prob_pokus))

    plt.show()



def simulace():

    pocet_trid = 100 # pocet simulace. Cim vetsi, tim presnejsi
    pocet_zaku = 23
    pocet_trid_kde_maji_dva_stejne_narozeniny = 0

    for nsimul in range(pocet_trid):

        narozeniny_ve_stejny_den = False
        datums_all = []
        for i in range(pocet_zaku):
            datum = random.randint(1, 365)
            if datum in datums_all:
                narozeniny_ve_stejny_den = True
                break
            else:
                datums_all.append(datum)

        if narozeniny_ve_stejny_den == True:
            pocet_trid_kde_maji_dva_stejne_narozeniny += 1

    print(pocet_trid_kde_maji_dva_stejne_narozeniny/pocet_trid)


def simulace_tesne_vedle(pocet_zaku):

    pocet_trid = 1000000 # pocet simulace. Cim vetsi, tim presnejsi
    # pocet_zaku = 14
    pocet_trid_kde_maji_dva_stejne_narozeniny = 0

    print("simulace tesne vedle pro %i zaku (%i nasimulovanych trid)" %(pocet_zaku, pocet_trid))

    for nsimul in range(pocet_trid):

        narozeniny_ve_stejny_den = False
        datums_all = []
        for i in range(pocet_zaku):
            datum = random.randint(0, 364)

            datum_pred = (datum - 1 + 365) % 365
            datum_po = (datum + 1) % 365

            if datum in datums_all or datum_pred in datums_all or datum_po in datums_all:
                narozeniny_ve_stejny_den = True
                break
            else:
                datums_all.append(datum)

        if narozeniny_ve_stejny_den == True:
            pocet_trid_kde_maji_dva_stejne_narozeniny += 1

    print(pocet_trid_kde_maji_dva_stejne_narozeniny/pocet_trid)

def pokus():

    pocet_zaku = 20
    datums_all = []

    for i in range(pocet_zaku):
        datum = random.randint(0, 3)

        podminka = datum in datums_all or (datum + 1) % 4 in datums_all
        print(datum, (datum + 1)%4, (datum - 1 + 4)%4)


        datums_all.append(datum)


def calc(n):

    res = (n * math.factorial(364 - n) + math.factorial(365 - n))/math.factorial(365 - 2*n)
    print(1- res/(365**n))

if __name__ == "__main__":

    # pokus()
    # simulace()

    # zavislost()
    # simulace()

    # zavislost_tesne_vedle()
    pocet_zaku = 14
    simulace_tesne_vedle(pocet_zaku)
    calc(pocet_zaku)
